#!/bin/bash

TV_SCRIPT_DIR="$(dirname "$0")"
TV_BIN_DIR="$(dirname "$TV_SCRIPT_DIR")"
TV_BASE_DIR="$(dirname "$TV_BIN_DIR")"
TV_LOG_DIR="$TV_BASE_DIR/logfiles"

function WaitForNetwork
{
  for ((TVD_CTR_NW=0; TVD_CTR_NW<10; TVD_CTR_NW++)); do
    CheckNetwork && break

    echo -n ':'
    sleep 1
  done
}

function WaitForConsoleKit
{
  [ -S /var/run/dbus/system_bus_socket ] || return
  [ -e /usr/share/dbus-1/system-services/org.freedesktop.ConsoleKit.service ] || return
  [ -x $(command -v "dbus-send" >/dev/null 2>&1) ] || return

  for ((TVD_CTR_CK=0; TVD_CTR_CK<10; TVD_CTR_CK++)); do
    StartConsoleKit
    CheckConsoleKit && break

    echo -n '.'
    sleep 1
  done
}

function WriteLog
{
  local timestamp="$(date +%F\ %H:%M:%S)"
  local consolekit='no ConsoleKit'
  local logfile="$TV_LOG_DIR/startup_daemon.log"
  local log_old="$logfile.old"

  [ -n "$TVD_CTR_CK" ] && consolekit="${TVD_CTR_CK}s (ConsoleKit)"

  echo "$timestamp Waited ${TVD_CTR_NW}s (network) / $consolekit" >> "$logfile"

  # trim log
  cmdExists wc || return
  cmdExists cat || return
  [ -f "$logfile" ] || return
  local linecnt=$(cat "$logfile" | wc -l)
  (( linecnt >= 100 )) && mv -f "$logfile" "$log_old"
}

function cmdExists()
{
  command -v "$1" >/dev/null 2>&1
}

function CheckNetwork
{
  # check network (interface is up, not only MAC)
  #  ip -4 link | grep 'link/' | grep -qv '00:00:00:00:00:00' || TVD_RESPONSE=''
  ip -4 addr | grep 'inet' | grep -qv 'inet 127.'
}

function CheckConsoleKit
{
  dbus-send --print-reply --system --dest=org.freedesktop.DBus / org.freedesktop.DBus.NameHasOwner string:org.freedesktop.ConsoleKit | grep -q true
}

function StartConsoleKit
{
  dbus-send --system --print-reply --dest=org.freedesktop.DBus / org.freedesktop.DBus.StartServiceByName string:org.freedesktop.ConsoleKit uint32:0
}

WaitForNetwork
WaitForConsoleKit
WriteLog

true
